/*
________________________________________________________________________________

   01.lookup-codes.sas 
   OPA Measure Calculations
   Step 1: Read in claims code lookup tables

   Summary  : Downloads lookup table and saves each worksheet to a SAS dataset.
   Saves codes into macro variables. 

   Authors  : P. Hastings / phil -at- farharbor -dot- com
            : H. Monti / holly -at- farharbor -dot- com  
            : Based on original code by B. Frederiksen -at- DHHS/OPA
   Version  : 1.03a
   Date     : 2018-08-20
   Revisions: None. 
   History  : 2016-12-19(1.00), 2017-02-22(1.01), 2017-05-17(1.02), 
              2018-04-20(1.03)

________________________________________________________________________________

*/

*...DO NOT EDIT: macro variables for setup;
%let DiagCodes = &DiagCodePrefix:;
%let DrugCodes = &DrugCodePrefix:;
%let ProcCodes = &ProcCodePrefix:;

*...Macro to standardize postpartum macro variable. Displays note in log if postpartum variable is set to no, blank, or has an invalid entrry that programs will default to all women (no
postpartum). If postpartum variable is set to yes, default calculations will be performed at 3 and 60 days postpartum unless otherwise specified in dayspp_list variable.;
%macro standpp/minoperator;
%symdel postpartum_st /nowarn ;
%global postpartum_st;
%if %length(&postpartum.) > 0 %then 
   %do;
   %if &postpartum. in yes YES Yes y Y %then 
      %do;
      %let postpartum_st = y;
      %end;
   %else %if &postpartum. in no NO No n N %then 
      %do;
      %let postpartum_st = n;
      %let dayspp_list = ;
      %put ;
      %put NOTE: Calculate contraceptive measures for all women.;
      %put NOTE: If interested in postpartum subpopulation, edit postpartum = yes in setup.;
      %put ;
      %end;
   %else 
      %do;
      %let postpartum_st = n;
      %let dayspp_list = ;
      %put ;
      %put NOTE: An entry other than yes or no was entered in the postpartum macro variable.;
      %put NOTE: Programs will default to all women. If interested in postpartum subpopulation, edit postpartum = yes in setup.; 
      %put ;
   %end;
%end;
%else 
   %do;
   %put ;
   %let postpartum_st = n;
   %let dayspp_list = ;
   %put NOTE: Calculate contraceptive measures for all women.;
   %put NOTE: If interested in postpartum subpopulation, edit postpartum = yes in setup.;
   %put ;
   %end;
%if &postpartum_st. = y %then 
   %do;
   %if %length(&dayspp_list.) = 0 %then 
      %do;
      %let dayspp_list = 3 60;
      %put ;
      %put NOTE: Default postpartum calculations will be performed at 3 and 60 days postpartum.;
      %put NOTE: If interested in other timeframes, edit dayspp_list = #days in setup.;
      %put ;
      %end;
   %else %do;
      %put ;
      %put NOTE: Postpartum calculations will be performed at %trim(&dayspp_list) days postpartum.;
      %put NOTE: If interested in other timeframes, edit dayspp_list = #days in setup.;
      %put ;
      %end;
   %end;
%mend standpp;
%standpp;
   
*===;
*...Save codes from OPA lookup tables into macro variables for later use;
*===;
proc sql noprint;
   select quote(strip(Diagnosis)) into :InfecundDiag separated by " " from lookup_Infecund_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :InfecundProc separated by " " from lookup_Infecund_&year. where missing(Procedure) ne 1;
   
   select quote(strip(Diagnosis)) into :PregDiag separated by " " from lookup_Pregnancy_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :PregProc separated by " " from lookup_Pregnancy_&year. where missing(Procedure) ne 1;
   
   select quote(strip(Diagnosis)) into :NonLiveBirthDiag separated by " " from lookup_Non_live_birth_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :NonLiveBirthProc separated by " " from lookup_Non_live_birth_&year. where missing(Procedure) ne 1;

   select quote(strip(Diagnosis)) into :LiveBirthDiag separated by " " from lookup_Live_birth_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :LiveBirthProc separated by " " from lookup_Live_birth_&year. where missing(Procedure) ne 1;

   select quote(strip(Diagnosis)) into :FemSterilDiag separated by " " from lookup_Sterilization_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :FemSterilProc separated by " " from lookup_Sterilization_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :FemSterilDrug separated by " " from lookup_Sterilization_&year. where missing(NDC) ne 1;

   select quote(strip(Diagnosis)) into :IUDDiag separated by " " from lookup_IUD_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :IUDProc separated by " " from lookup_IUD_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :IUDDrug separated by " " from lookup_IUD_&year. where missing(NDC) ne 1;

   select quote(strip(Diagnosis)) into :ImplantDiag separated by " " from lookup_Implant_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :ImplantProc separated by " " from lookup_Implant_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :ImplantDrug separated by " " from lookup_Implant_&year. where missing(NDC) ne 1;

   select quote(strip(Diagnosis)) into :InjectDiag separated by " " from lookup_Injectable_&year. where missing(Diagnosis) ne 1; 
   select quote(strip(Procedure)) into :InjectProc separated by " " from lookup_Injectable_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :InjectDrug separated by " " from lookup_Injectable_&year. where missing(NDC) ne 1;

   select quote(strip(Diagnosis)) into :OCDiag separated by " " from lookup_Oral_Pill_&year. where missing(Diagnosis) ne 1;
   select quote(strip(Procedure)) into :OCProc separated by " " from lookup_Oral_Pill_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :OCDrug separated by " " from lookup_Oral_Pill_&year. where missing(NDC) ne 1;

   select quote(strip(Diagnosis)) into :PatchDiag separated by " " from lookup_Patch_&year. where missing(Diagnosis) ne 1; 
   select quote(strip(Procedure)) into :PatchProc separated by " " from lookup_Patch_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :PatchDrug separated by " " from lookup_Patch_&year. where missing(NDC) ne 1;

   select quote(strip(Diagnosis)) into :VagRingDiag separated by " " from lookup_Ring_&year. where missing(Diagnosis) ne 1; 
   select quote(strip(Procedure)) into :VagRingProc separated by " " from lookup_Ring_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :VagRingDrug separated by " " from lookup_Ring_&year. where missing(NDC) ne 1;

   select quote(strip(Diagnosis)) into :DiaphragmDiag separated by " " from lookup_Diaphragm_&year. where missing(Diagnosis) ne 1; 
   select quote(strip(Procedure)) into :DiaphragmProc separated by " " from lookup_Diaphragm_&year. where missing(Procedure) ne 1;
   select quote(strip(NDC))       into :DiaphragmDrug separated by " " from lookup_Diaphragm_&year. where missing(NDC) ne 1;
   
quit; 

*===;
*  Categorize most, moderately effective, and LARC-related methods;
*===;

*...Most effective methods (Female Sterilization, Intrauterine device (IUD/IUS), and Hormonal implant);
%let MostEffectProc=&FemSterilProc &IUDProc &ImplantProc;
%let MostEffectDiag=&FemSterilDiag &IUDDiag &ImplantDiag;
%let MostEffectDrug=&FemSterilDrug &IUDDrug &ImplantDrug; 

*...Moderately effective methods (Injectable, Oral contraceptive, Patch, Ring, Diaphragm);
%let ModEffectProc=&InjectProc &OCProc &PatchProc &VagRingProc &DiaphragmProc;
%let ModEffectDiag=&InjectDiag &OCDiag &PatchDiag &VagRingDiag &DiaphragmDiag;
%let ModEffectDrug=&InjectDrug &OCDrug &PatchDrug &VagRingDrug &DiaphragmDrug;

*...Most/moderately effective methods (Female Sterilization, Intrauterine device (IUD/IUS), 
    Hormonal implant, Injectable, Oral contracptive, Patch, Ring, Diaphragm);
%let MostModProc=&FemSterilProc &IUDProc &ImplantProc &InjectProc &OCProc &PatchProc &VagRingProc &DiaphragmProc;
%let MostModDiag=&FemSterilDiag &IUDDiag &ImplantDiag &InjectDiag &OCDiag &PatchDiag &VagRingDiag &DiaphragmDiag; 
%let MostModDrug=&FemSterilDrug &IUDDrug &ImplantDrug &InjectDrug &OCDrug &PatchDrug &VagRingDrug &DiaphragmDrug; 

*...LARC codes = IUD/IUS + Hormonal Implants;
%let LARCProc=&IUDProc &ImplantProc;
%let LARCDiag=&IUDDiag &ImplantDiag;
%let LARCDrug=&IUDDrug &ImplantDrug;




