/*
________________________________________________________________________________

   00.setup.sas 
   OPA Measure Calculations
   Step 0: Define macro variables

   Summary  : Define macro variables used in subsequent programs.
              User enters environment- and data-specific info (directories,
              variable names). User specifies whether to perform measure 
              calculations on postpartum women (and number of days postpartum). 
              Measure calculations will be performed on all women population 
              by default. User can also specify demographic variables for 
              stratification of final measures.

   Data Reqs: 1) A sas data file containing women with one calendar year of claims
              2) Every record must contain at least: 
                  a) patient ID 
                  b) patient date of birth (or age at service date)
                  c) date of service

   Authors  : P. Hastings / phil -at- farharbor -dot- com
            : H. Monti / holly -at- farharbor -dot- com  
            : Based on original code by B. Frederiksen -at- DHHS/OPA
   Version  : 1.03a
   Date     : 2018-08-20
   Revisions: Upgrades to setup helper to allow for various data types such
              as character and non-sas dates. Options to use Patient Age or DOB
              for exclusions. Update LARC component with latest NQF-endorsed
              change that counts even those with LARC removals in numerator. 
              Enables use of claim code tables from different years (including 
              ICD9 and ICD10). Update method of downloading code tables. Update 
              method of identifying pregnancy exclusions and separating episodes 
              of live birth. Produces logs and de-identified data for 
              troubleshooting and technical assistance. Updated instructions 
              about eligible population. 
   History  : 2016-12-19(1.00), 2017-02-22(1.01), 2017-05-17(1.02), 
              2018-04-20(1.03)

________________________________________________________________________________

*/
*...Session Options, DO NOT EDIT the 4 lines below;
options LS=150 PS=60 PAGENO=1 NODATE OBS=MAX FORMCHAR='|---|+|---+=|-/\<>*';    *...DO NOT EDIT. Typical SAS options for reporting style;
%symdel data_dir DSN postpartum dayspp_list stratifying_var_list /nowarn ;      *...DO NOT EDIT. Clear optional macro vars for clean run;
%global urldir data_dir year work_temp;                                         *...DO NOT EDIT. Name global macro vars;
%let work_temp = %sysfunc(pathname(work));                                      *...DO NOT EDIT. Identify SAS work directory;
*...End Session Options;

*=============================================================================;
*   ELIGIBILITY: ALL WOMEN CONTRACEPTIVE CARE MEASURES 
*=============================================================================;
*   To calculate the measures among all women of reproductive age:
*   Your claims dataset should consist entirely of women ages 
*   15-44 years. The dataset should include: 
*      a) General Medicaid recipients who are continuously enrolled in the 
*         measurement year, defined as no more than one gap in enrollment 
*         of up to 45 days during the continuous enrollment period, and    
*      b) Family Planning Waiver recipients (regardless of continuous 
*         enrollment).
*   
*   For cases of eligible women having no claims in the measurement year, add a 
*   single record to the dataset with a unique Patient ID, Date of Birth (or 
*   age if DOB is not available), and January 1 assigned as the Date of 
*   Service (enabling these cases to be included in the denominator). 
* 
*   Women outside of the ages 15-44 years as well as records without dates 
*   occurring in the measurement year are automatically excluded from the 
*   analysis. 
*   
*=============================================================================;
*   ELIGIBILITY: OPTIONAL POSTPARTUM WOMEN CONTRACEPTIVE CARE MEASURES 
*=============================================================================;
*   To calculate contraceptive care measures among postpartum women: 
*   A similarly formatted dataset as above should be used, with one important 
*   difference. The dataset must include all women ages 15-44 years -- 
*   REGARDLESS of enrollment status. Continuous enrollment is not required for 
*   postpartum measures, because women remain enrolled in Medicaid for their 
*   entire 60-day postpartum measurement period.
*
*=============================================================================;
*   DATA REQUIREMENTS: 
*=============================================================================;
*   Your input SAS dataset (*.sas7bdat) must be at the claims level (multiple 
*   records per woman per encounter, each record being a separate claim). Your 
*   dataset should contain an entire calendar year of data.   
*   Required variables are: unique patient ID, date of service, age at date of 
*   service, and diagnosis, procedure, and drug codes.;


*=============================================================================;
*  USER SETUP: EDIT USER-DEFINED VARIABLES BELOW for your data. 
*=============================================================================;
*...REQUIRED EDITS SECTION...;
*   Specify your data and variable names below. 
*
*   IMPORTANT: Only edit to the RIGHT-> of the equal sign "="! Do not change 
*   the names of macro variables to the LEFT of the equal sign "=" or the 
*   programs will not function.;

filename OPA "D:\your_program_folder_location\";                *...Edit ONLY location inside the "quotes" for where programs are stored (preserve the OPA filename);
%let Year = YourYear;                                           *...Edit ONLY YourYear variable name (preserve the "Year" macro name);
%let data_dir = D:\your_data_folder_location;                   *...Edit ONLY location for your SAS claims dataset (preserve the data_dir macro name);
%let DSN = YourDatasetName;                                     *...Edit ONLY YourDatasetName (preserve the "DSN" macro name) -- AND ensure correct eligibility (see above);
%let PatientID = YourPatientIDVar;                              *...Edit ONLY YourPatientIDVar variable name (preserve the "PatientID" macro name);
%let PatientDOB = YourPatientDOB;                               *...Edit ONLY YourPatientDOB, the service date variable in your data. Must be a SAS date.;
%let DateOfService = YourDateOfServiceVar;                      *...Edit ONLY YourDateOfServiceVar, the service date variable in your data. Must be a SAS date.;

*...NOTE: Diagnosis code, procedure code, and drug code variables should each 
*   have a common prefix, unique for each type of code. For example if your 
*   dataset contains 10 drug code variables per claim, the drug variables could 
*   be named NDC1, NDC2,..., NDC10, and the PREFIX entered below would simply be 
*   "NDC". No other variables should begin with the prefix NDC. The same rules 
*   apply for the diagnosis and procedure codes. If codes are just a single 
*   variable in your data, enter the whole variable name;
*...IMPORTANT: ONLY EDIT to the RIGHT==> of the equal sign "=" to specify your variables;

%let DiagCodePrefix = ICD;                                      *...Edit ONLY ICD, the prefix for your diagnosis code variables (preserve DiagCodePrefix name);
%let ProcCodePrefix = PRC;                                      *...Edit ONLY PRC, the prefix for your procedure code variables (preserve ProcCodePrefix name);
%let DrugCodePrefix = NDC;                                      *...Edit ONLY NDC, the prefix for your drug code variables (preserve DrugCodePrefix name);

*...END REQUIRED EDITS SECTION...;

*...START OPTIONAL EDITS SECTION...;

*...OPTIONAL: Specify a list of variables for stratified reporting (BY variable)
*   of the final measures. Enter your variable names as a list with spaces in 
*   between (or leave blank);                     

%let stratifying_var_list = ;                                                                

*...OPTIONAL: Use patient age at date of last service instead of PatientDOB for age 
*   exclusions (default=N, only use this if PatientDOB is not available).                     
*...NOTE: The Ageatdateofservice variable below should be numeric (in years); 

%let UseSvcAgeforExclusions = ;                                 *...Y/N, default=N (or leave blank) ;                               
%let Ageatdateofservice = ;                                     *...Patient age at encounter, in years (leave blank if using PatientDOB);


*...OPTIONAL: POSTPARTUM CONTRACEPTIVE CARE MEASURES  
*   By default this option is blank and no postpartum measures are calculated.
*   If calculating postpartum, read the ELIGIBILITY section above and use 
*   the correct dataset (in the %let DSN= line above).
* 
*   To calculate the postpartum measures, specify Y or N (yes/no) below. 
*   When postpartum is calculated, the default period of time is 3- and 
*   60-days and a note appears in the log. You may specify different time 
*   periods if desired with the dayspp_list option.;

%let postpartum = ;                                              *...Y/N, default=N (or leave blank) ;                               
%let dayspp_list = ;                                             *...OPTIONAL: # of days postpartum as a list with spaces (e.g. dayspp_list = 3 60 90).;                                                                    

*=============================================================================;
*  END USER SETUP SECTION
*=============================================================================;

libname CC "&data_dir.\";                                       *...DO NOT EDIT: Programs expect the 'CC' libname;

*...SETUP_HELPER: Prepares your dataset for analysis, shows details about your data, saves a pdf of the
*   contents of your data, and saves a technical log file for troubleshooting...;
%include OPA("setup_helper.sas") /source2; 

*=============================================================================;
*  DOWNLOAD THE LATEST LOOKUP TABLES WITH CONTRACEPTIVE CLAIMS CODES 
*=============================================================================;
*...NOTE: This section requires SAS 9.4 or higher. PROC HTTP is used to download
    the latest OPA lookup tables from the web to your WORK directory. If you  
    have an earlier version of SAS, manually download the latest lookup tables 
    listed below into your WORK directory and skip this section, like this:
    https://www.hhs.gov/opa/sites/default/files/<<tablename>>.sas7bdat

    For example the 2017 IUD table is here: 
    https://www.hhs.gov/opa/sites/default/files/lookup_iud_2017.sas7bdat
;

%let urldir = https://www.hhs.gov/opa/sites/default/files/;     *...DO NOT EDIT. Published web location of lookup tables ;
%macro getlookup(tablename);
   filename _inbox "%sysfunc(getoption(work))/&tablename..sas7bdat";
   proc http 
      method="get" url="&urldir.&tablename..sas7bdat" out=_inbox;
      run;
%mend;
*...Claims code tables will now be downloaded to work library and directly readable;
%getlookup(lookup_iud_&year.);  
%getlookup(lookup_infecund_&year.);
%getlookup(lookup_pregnancy_&year.);
%getlookup(lookup_non_live_birth_&year.);
%getlookup(lookup_live_birth_&year.);
%getlookup(lookup_sterilization_&year.);
%getlookup(lookup_implant_&year.);
%getlookup(lookup_injectable_&year.);
%getlookup(lookup_oral_pill_&year.);
%getlookup(lookup_patch_&year.);
%getlookup(lookup_ring_&year.);
%getlookup(lookup_diaphragm_&year.);

*=============================================================================;
*  END DOWNLOAD OF LOOKUP TABLES SECTION
*=============================================================================;

*=============================================================================;
*  YOU MAY NOW RUN THE PROGRAMS IN ORDER USING THE STATEMENTS BELOW 
*  (OR YOU CAN SIMPLY SUBMIT THE INDIVIDUAL PROGRAMS IN THE SAS EDITOR)
*=============================================================================;
%include OPA("01.lookup-codes.sas") /source2;     
%include OPA("02.flag-methods.sas") /source2;  
%include OPA("03.make-denominator.sas") /source2; 
%include OPA("04.make-numerator.sas") /source2;  
%include OPA("05.report-rates.sas") /source2;   


